<?php

/**
 * Detailed endpoint documentation
 * Billets: https://dev.efipay.com.br/docs/api-cobrancas/boleto#retornar-lista-de-cobranças
 * Cards: https://dev.efipay.com.br/docs/api-cobrancas/cartao#retornar-lista-de-cobranças
 */

$autoload = realpath(__DIR__ . "/../../../vendor/autoload.php");
if (!file_exists($autoload)) {
    die("Autoload file not found or on path <code>$autoload</code>.");
}
require_once $autoload;

use Efi\Exception\EfiException;
use Efi\EfiPay;

$optionsFile = __DIR__ . "/../../credentials/options.php";
if (!file_exists($optionsFile)) {
	die("Options file not found or on path <code>$options</code>.");
}
$options = include $optionsFile;

$params = [
	"charge_type" => "subscription",
	"begin_date" => "2024-01-01",
	"end_date" => "2024-12-31",
	// "date_of" => "2024-12-31.", // "creation","payment", "due"
	// "status" => "paid", // "new","waiting", "paid", "unpaid","canceled", "identified","settled".
	// "customer_document" => "00000000000", // CPF or CNPJ 
	// "custom_id" => "000001",
	// "value" => "9990",
	// "limit" => 50,
	// "page" => 2
	// "offset" => 25
];

try {
	$api = new EfiPay($options);
	$response = $api->listCharges($params);

	if (isset($options["responseHeaders"]) && $options["responseHeaders"]) {
		print_r("<pre>" . json_encode($response->body, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) . "</pre>");
		print_r("<pre>" . json_encode($response->headers, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) . "</pre>");
	} else {
		print_r("<pre>" . json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) . "</pre>");
	}
} catch (EfiException $e) {
	print_r($e->code . "<br>");
	print_r($e->error . "<br>");
	print_r($e->errorDescription) . "<br>";
	if (isset($options["responseHeaders"]) && $options["responseHeaders"]) {
		print_r("<pre>" . json_encode($e->headers, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) . "</pre>");
	}
} catch (Exception $e) {
	print_r($e->getMessage());
}
